<?php
/**
 * Plugin Name: Tooltastic Sales Popup
 * Plugin URI: https://tooltastic.eu/sales-popup
 * Description: Social-Proof-Benachrichtigungen (Käufe, Bewertungen, Knappheit) als Popup auf deiner Website. Konfigurierbar über das Tooltastic-Dashboard.
 * Version: 1.1.0
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Author: Tooltastic
 * Author URI: https://tooltastic.eu
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: tooltastic-sales-popup
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}

define('TOOLTASTIC_SP_VERSION', '1.1.0');
define('TOOLTASTIC_SP_FILE', __FILE__);
define('TOOLTASTIC_SP_DIR', plugin_dir_path(__FILE__));
define('TOOLTASTIC_SP_URL', plugin_dir_url(__FILE__));
define('TOOLTASTIC_SP_WIDGET_URL', 'https://tooltastic.eu/widget/sales-popup.js');
define('TOOLTASTIC_SP_API_URL', 'https://tooltastic.eu/api/widgets');

/**
 * Initialize the plugin.
 */
function tooltastic_sp_init() {
    require_once TOOLTASTIC_SP_DIR . 'includes/class-settings.php';
    require_once TOOLTASTIC_SP_DIR . 'includes/class-frontend.php';

    // Migrate from v1.0 single campaign_id to multi-campaign array
    tooltastic_sp_maybe_migrate();

    if (is_admin()) {
        Tooltastic_SP_Settings::init();
    }

    Tooltastic_SP_Frontend::init();
}
add_action('plugins_loaded', 'tooltastic_sp_init');

/**
 * Migrate from v1.0.0 (single campaign_id) to v1.1.0 (campaigns array).
 */
function tooltastic_sp_maybe_migrate() {
    $campaigns = get_option('tooltastic_sp_campaigns', []);
    if (!empty($campaigns)) {
        return; // Already migrated
    }

    $old_campaign_id = get_option('tooltastic_sp_campaign_id', '');
    if (empty($old_campaign_id)) {
        return; // Nothing to migrate
    }

    $campaigns = [[
        'label'       => __('Standard', 'tooltastic-sales-popup'),
        'campaign_id' => $old_campaign_id,
        'mode'        => 'all',
        'pages'       => '',
    ]];

    update_option('tooltastic_sp_campaigns', $campaigns);
}

/**
 * Activation hook – set default options.
 */
function tooltastic_sp_activate() {
    $defaults = [
        'api_key'         => '',
        'campaign_id'     => '',
        'campaigns'       => [],
        'enabled'         => '1',
        'exclude_pages'   => '',
        'woo_integration' => '0',
    ];

    foreach ($defaults as $key => $value) {
        if (get_option('tooltastic_sp_' . $key) === false) {
            add_option('tooltastic_sp_' . $key, $value);
        }
    }
}
register_activation_hook(__FILE__, 'tooltastic_sp_activate');

/**
 * Add settings link on the plugins page.
 */
function tooltastic_sp_settings_link($links) {
    $url = admin_url('options-general.php?page=tooltastic-sales-popup');
    $settings_link = '<a href="' . esc_url($url) . '">' . esc_html__('Einstellungen', 'tooltastic-sales-popup') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'tooltastic_sp_settings_link');
